;*
;* JAVA VIRTUAL MACHINE FOR APPLE II PRODOS
;*
	.INCLUDE	"global.inc"
	.INCLUDE	"class.inc"
	.IMPORT	UTIL_INIT,HOME,GETLN,PRSTR,CROUT,PUTS,PRBYTE,KBWAIT,MEMCPY
	.IMPORT	HMEM_INIT,HMEM_ALLOC,HMEM_FREE
	.IMPORT	HMEM_PTR,HMEM_REF_INC,HMEM_REF_DEC,HMEM_LOCK,HMEM_GC
	.IMPORT	HSTR_INIT,STR_HASH,HSTR_HASH,HSTRPL_ADD,HSTRPL_DEL
	.IMPORT	LOADCLASS_INIT,IO_INIT,FILE_OPEN,FILE_CLOSE
	.IMPORT	HCLASS_INIT,HCLASS_NAME,HCLASS_HNDL,CLASS_MATCH_NAME,CLASS_MATCH_DESC
	.IMPORT	RESOLVE_CLASS,RESOLVE_METHOD,CLASS_METHODPTR
	.IMPORT	SYSCLASS_INIT,EXCEPT_INIT
	.IMPORT	HMAINNAMESTR,HMAINDESCSTR
	.IMPORT	THREAD_INIT,THREAD_NEW,THREAD_SETRUN,THREAD_YIELD
	.IMPORT	ITHREAD_PUSH_SP,ITHREAD_PUSH_TLS,LOADEXECSTATE,BEST_THREAD
	.IMPORT	INTERP_INIT,INTERP_END
	.EXPORT	INIT_START,VM_SHUTDOWN

.IFDEF	DEBUG
	.IMPORT	HMEM_DUMP,HSTRPL_DUMP,KBWAIT
.ENDIF

PARSELEN	EQU	$A0
	.SEGMENT "INIT"
INIT_START:
VM_INIT:	LDX	#$FF
	TXS
	JSR	HOME
	PSTRLN	"VM02 PREVIEW VERSION 0.6"
	PSTRLN	"COPYRIGHT 2008, DAVID SCHMENK"
.IFDEF	DEBUG
	PSTRLN	"DEBUG ENABLED"
.ENDIF
.IFDEF	DEBUG_DUMP
	LDA	#$00		; TURN ON PRINTER
	STA	CSWL
	LDA	#$C1
	STA	CSWH
.ENDIF
	JSR	UTIL_INIT
	JSR	HMEM_INIT
	JSR	HSTR_INIT
	JSR	HCLASS_INIT
	JSR	INTERP_INIT
	JSR	LOADCLASS_INIT
	JSR	SYSCLASS_INIT
	JSR	THREAD_INIT
	JSR	IO_INIT
	JSR	EXCEPT_INIT
	LDA	#<VM_SHUTDOWN
	STA	LINK_EXIT
	LDA	#>VM_SHUTDOWN
	STA	LINK_EXIT+1
;
; LOOK FOR STARTUP FILE
;
	LDA	#<STARTUPSTR
	LDX	#>STARTUPSTR
	JSR	FILE_OPEN
	BCS	CMDLINE
	JSR	FILE_CLOSE
	LDA	#$00
	STA	PARSELEN
	PHA
	LDA	#<STARTUPSTR
	LDX	#>STARTUPSTR
	BNE	SETCALLCLASS
;
; PROMPT FOR MAIN CLASS
;
CMDLINE:	PSTR	"MAIN CLASS"
	LDA	#':'|$80
	STA	PROMPTCHAR
	JSR	GETLN
	CPX	#$00
	BNE	:+
	JMP	VM_SHUTDOWN
:	STX	PARSELEN
	LDX	#$00
	JSR	PARSELINE	
	TXA			; CLEVERLY PUT STRING LENGTH
	PHA			; IN FRONT OF INPUT BUFFER AT $200
	LDA	#$FF
	LDX	#$01
SETCALLCLASS:	JSR	HSTRPL_ADD
	STA	CALLCLASS
	STX	CALLCLASS+1
PARSEARGS:	PLA
	BEQ	:+
	TAX
	JSR	PARSELINE
	TXA
	BEQ	:+
	PHA
	LDA	#$FF
	LDX	#$01
	JSR	HSTRPL_ADD
	STY	TMP
	LDY	NARGS
	STA	HARGSL,Y
	TXA
	STA	HARGSH,Y
	LDA	TMP
	STA	ARGSHASH,Y
	INC	NARGS
	BNE	PARSEARGS
:	LDA	NARGS		; ALLOCATE ARGS ARRAY
	ASL
	ASL
	CLC
	ADC	#$02
	LDX	#$00
	LDY	#$01
	JSR	HMEM_ALLOC
	STA	HARGS
	STX	HARGS+1
	JSR	HMEM_PTR
	STA	$A0
	STX	$A1
	LDY	#$00
	LDA	NARGS
	STA	($A0),Y
	TYA
	TAX
	INY
	STA	($A0),Y
	LDA	NARGS
	BEQ	:+
	INY
FILLARGS:	LDA	HARGSL,X
	STA	($A0),Y
	INY
	LDA	HARGSH,X
	STA	($A0),Y
	INY
	LDA	#CL_STR
	STA	($A0),Y
	INY
	LDA	ARGSHASH,X
	STA	($A0),Y
	INY
	INX
	DEC	NARGS
	BNE	FILLARGS
RUNMAIN:	LDA	#$00		; NEED TO CREATE THREAD INSTANCE OBJECT
:	TAX
	JSR	THREAD_NEW
	LDA	#T_REF
	LDX	#CL_ARRAY
	JSR	ITHREAD_PUSH_SP		; PUSH MAIN PARAM ON STACK
	LDA	HARGS+1
	LDX	HARGS
	JSR	ITHREAD_PUSH_SP
	LDA	HMAINNAMESTR		; RUN MAIN METHOD
	LDX	HMAINNAMESTR+1
	JSR	ITHREAD_PUSH_SP
	LDA	HMAINDESCSTR
	LDX	HMAINDESCSTR+1
	JSR	ITHREAD_PUSH_SP
	LDA	CALLCLASS		; RETRIEVE CLASS NAME
	LDX	CALLCLASS+1
	JSR	ITHREAD_PUSH_SP
	JSR	THREAD_SETRUN
	STY	BEST_THREAD
	LDA	#$00		; CLEAR INPUT BUFFER
	STA	$0200
	BIT	CLRKBD
	JSR	LOADEXECSTATE		; JUMP TO SCHEDULER
	PERR	"OOPS, RETURN FROM YIELD"
	BRK
	LDA	INTERP_END		; DUMMY READ TO MAKE EXTERN SHOW UP IN MAP FILE
PARSELINE:	LDY	#$00		; SKIP PREVIOUS STRING
	LDA	INQUOTE
	BEQ	:+
	DEC	INQUOTE
	INX
:	LDA	PARSELEN
	STX	PARSELEN
	SEC
	SBC	PARSELEN
	STA	PARSELEN
	BNE	SKIPPREV
PARSEDONE:	LDX	#$00
	RTS
SKIPPREV:	LDA	$0200,X
	STA	$0200,Y
	INY
	INX
	BNE	SKIPPREV
SKIPSPACE:	LDA	$0200
	CMP	#'"'|$80
	BEQ	PARSEQUOTE
	CMP	#$A1		; CHECK FOR WHITESPACE
	BCS	PARSESTR
	DEC	PARSELEN
	BEQ	PARSEEXIT
:	LDA	$0201,X		; SHIFT BUFFER DOWN
	STA	$0200,X
	INX
	BNE	:-
	BEQ	SKIPSPACE
PARSESTR:	INX
	CPX	PARSELEN
	BEQ	PARSEEXIT
	LDA	$0200,X
	CMP	#$A1
	BCS	PARSESTR
PARSEEXIT:	RTS
PARSEQUOTE:	DEC	PARSELEN
:	LDA	$0201,X		; SKIP QUOTE CHAR
	STA	$0200,X
	INX
	BNE	:-
	BEQ	:+
FINDQUOTE:	INX
:	CPX	PARSELEN
	BEQ	PARSEEXIT
	LDA	$0200,X
	CMP	#'"'|$80
	BNE	FINDQUOTE
	INC	INQUOTE
	RTS
STARTUPSTR:	.BYTE	7,"STARTUP"		; AUTO RUN STARTUP CLASS
CALLCLASS:	.WORD	$0000
NARGS:	.BYTE	$00
INQUOTE:	.BYTE	$00
HARGSL:	.RES	10
HARGSH:	.RES	10
ARGSHASH:	.RES	10
HARGS:	.WORD	$0000

	.CODE
;*
;* MAIN ENTRYPOINT
;*
;	ORG	$1000
VM_STARTUP:	JMP	VM_INIT
;*
;* ALL THREADS ARE DONE, OR AN UNRECOVERABLE ERROR OCCURED
;* EXIT TO PRODOS
;*
VM_SHUTDOWN:	PHA
	TXA
	PHA
	JSR	CROUT
	PSTR	"VM02 EXITING WITH STATUS: "
	PLA
	JSR	PRBYTE
	PLA
	JSR	PRBYTE
	JSR	CROUT
	PSTR	"PRESS ANY KEY TO REBOOT..."
	JSR	KBWAIT
	BIT	ROMIN		; SWAP ROM IN
	LDA	#$00
	STA	$3F4		; INVALIDATE POWER-UP BYTE
	JMP	($FFFC)		; RESET
